library(keras)
library(tensorflow)
library(tidyverse)
df <- readRDS(url("https://files.nagbalae.hu/public/2024-03-29.rds"))
df <- df |> select(Vételár,Évjárat,Állapot,Kivitel,Kmóraállás, Sajáttömeg,Teljesítmény) |>
	mutate(Kor = 2024-Évjárat, Vételár = log(Vételár), Kmóraállás=log(Kmóraállás)) |>
			select(-Évjárat) |> na.omit() |>
	subset(Kivitel %in% c("Cabrio","Coupe","Egyterű","Ferdehátú","Sedan","Városi terepjáró (crossover)")) |>
	droplevels() |> filter(Kmóraállás > 0 & Kor >= 0)
summary(lm(Vételár ~., df))
##############tanító és tesztelő halmaz készítése
trainIndex <- createDataPartition(df$Vételár, p = 0.8, 
                                  list = FALSE, 
                                  times = 1)


data_train <- df[trainIndex, ]
 data_test<- df[-trainIndex, ]

#################döntési fa


fa <- rpart(Vételár~., data=data_train)
rpart.plot(fa)

predictions <- predict(fa, newdata = data_test)

actual_values <- data_test$Vételár
r_squared <- 1 - sum((actual_values - predictions)^2) / sum((actual_values - mean(actual_values))^2)

print(paste("R négyzet értéke:", round(r_squared, 4)))

#parameter tuning
library(rpart)
library(caret)

ctrl <- trainControl(method = "cv", number = 10)

hyperparameters <- expand.grid(cp = seq(0.01, 0.1, by = 0.01))
tuned_model <- caret::train(Vételár ~ ., data = data_train, method = "rpart",
                     trControl = ctrl, tuneGrid = hyperparameters)

print(tuned_model)

best_cp <- tuned_model$bestTune$cp
print(paste("Best cp:", best_cp))
#legjobb modell elkészítése
best_tree <- rpart(Vételár ~ ., data = data_train, cp = best_cp)
rpart.plot(best_tree)

predictions <- predict(best_tree, newdata = data_test)

r_squared <- 1 - sum((actual_values - predictions)^2) / sum((actual_values - mean(actual_values))^2)
print(paste("R négyzet értéke:", round(r_squared, 4)))

####### Véletlen erdő
rf <- randomForest(Vételár~., data=data_test, ntree=100, mtry=3)
varImpPlot(rf)
actual_values<- data_train$Vételár
predictions <- predict(rf, newdata = data_train)
r_squared <- 1 - sum((actual_values - predictions)^2) / sum((actual_values - mean(actual_values))^2)
print(paste("R négyzet értéke:", round(r_squared, 4)))

#paraméter hangolás
control <- trainControl(method = "cv", number = 5, search = "grid")

tuneGrid <- expand.grid(
  .mtry = c(1, 2, 3, 4, 5)
)


rf_tuned <- caret::train(
  Vételár ~ ., 
  data = data_test, 
  method = "rf", 
  trControl = control, 
  tuneGrid = tuneGrid
)
#legjobb modell elkészítése
best_mtry<- rf_tuned$bestTune$mtry
best_rf<-randomForest(Vételár~., data=data_test, ntree=100, mtry=best_mtry)
varImpPlot(rf)


predictions <- predict(best_rf, newdata = data_train)
r_squared <- 1 - sum((actual_values - predictions)^2) / sum((actual_values - mean(actual_values))^2)
print(paste("R négyzet értéke:", round(r_squared, 4)))

###### boosting
library(xgboost)

y_train <- data_train$Vételár
X_train <- data_train[, !names(data_train) %in% "Vételár"]

y_test <- data_test$Vételár
X_test <- data_test[, !names(data_test) %in% "Vételár"]
X_train <- dummy_cols(X_train, remove_first_dummy=TRUE, remove_selected_columns=TRUE)
X_test <- dummy_cols(X_test, remove_first_dummy=TRUE, remove_selected_columns=TRUE)

xgb_model <- xgboost(data = as.matrix(X_train), label = y_train, objective = "reg:squarederror", nrounds = 100)

predictions <- predict(xgb_model, as.matrix(X_test))

r_squared <- 1 - sum((y_test - predictions)^2) / sum((y_test - mean(y_test))^2)
print(paste("R négyzet értéke a teszt adaton:", round(r_squared, 4)))
#hangolás
control <- trainControl(method = "cv", number = 5, search = "grid")
tuneGrid <- expand.grid(
  eta = c(0.01, 0.1, 0.3, 0.5),  
  max_depth = c(3, 6, 9),   
  nrounds = 100,           
  gamma = 0,               
  colsample_bytree = 1,  
  min_child_weight = 1,     
  subsample = 1           
)


xgb_tuned <- caret::train(
  Vételár ~ ., 
  data = data_train, 
  method = "xgbTree", 
  trControl = control, 
  tuneGrid = tuneGrid,
  metric = "RMSE"
)
#legjobb modell elkészítése
best_eta<- xgb_tuned$bestTune$eta
best_maxdeoth<- xgb_tuned$bestTune$max_depth
xgb_model <- xgboost(data = as.matrix(X_train), label = y_train, objective = "reg:squarederror", nrounds = 100, eta=best_eta, maxdepth=best_maxdeoth)

predictions <- predict(xgb_model, as.matrix(X_test))

r_squared <- 1 - sum((y_test - predictions)^2) / sum((y_test - mean(y_test))^2)
print(paste("R négyzet értéke a teszt adaton:", round(r_squared, 4)))

ggcorrplot(corr=cor(df[,c(1,4:7)]))
