library(keras)
library(tensorflow)
library(tidyverse)
library(dplyer)
#adatok beolvasása és szűrése
df <- readRDS(url("https://files.nagbalae.hu/public/2024-03-29.rds"))
df <- df |> select(Vételár,Évjárat,Állapot,Kivitel,Kmóraállás, Üzemanyag, Sajáttömeg,Teljesítmény) |>
	mutate(Kor = 2024-Évjárat, Vételár = log(Vételár), Kmóraállás=log(Kmóraállás)) |>
			select(-Évjárat) |> na.omit() |>
	subset(Kivitel %in% c("Cabrio","Coupe","Egyterű","Ferdehátú","Sedan","Városi terepjáró (crossover)")) |>
	droplevels() |> filter(Kmóraállás > 0 & Kor >= 0)
summary(lm(Vételár ~., df))
#SVM-hez használt kategóriaváltozó létrehozása
df_filtered <- df %>%
  filter(Üzemanyag %in% c("Benzin/Gáz", "Dízel", "Elektromos"))

df_filtered <- df_filtered %>%
  mutate(Üzemanyag_new = case_when(
    Üzemanyag %in% c("Benzin/Gáz", "Dízel") ~ "Fosszilis",
    Üzemanyag == "Elektromos" ~ "Elektromos"
  ))

df_filtered$Üzemanyag_new <- as.factor(df_filtered$Üzemanyag_new)
#szükséges változók df-be rendezése
df_selected <- df_filtered %>%
  select(Üzemanyag_new, Vételár, Kmóraállás, Sajáttömeg, Teljesítmény, Kor)

ggplot(df_selected, aes(x = Kor, y = Teljesítmény, color = Üzemanyag_new)) +
  geom_jitter() 


library(e1071)
library(caret)

df_selected$Üzemanyag_new <- as.factor(df_selected$Üzemanyag_new)
#teszt és train adat szétválasztása
train_indices <- createDataPartition(df_selected$Üzemanyag_new, p = 0.8, list = FALSE)
train_data <- df_selected[train_indices, ]
test_data <- df_selected[-train_indices, ]

#nem standardizált svm modell, a kerneleknél többet kipróbáltunk, ez adja a legjobb eredményt
svm_model <- svm(Üzemanyag_new ~ ., data = train_data, kernel = "radial")

predictions <- predict(svm_model, test_data)
confusion_matrix <- table(Predicted = predictions, Actual = test_data$Üzemanyag_new)
print(confusion_matrix)

#pontosság kiszámítása
accuracy <- sum(diag(confusion_matrix)) / sum(confusion_matrix)
print(paste("Pontosság:", accuracy))
summary(test_data)

test_data$pred<-predictions
#becsült és valós adatok
ggplot(test_data, aes(x = Kor, y = Teljesítmény, color = pred)) +
  geom_point(size = 2)
ggplot(test_data, aes(x = Kor, y = Teljesítmény, color = Üzemanyag_new)) +
  geom_point(size = 2)

test_data$helyes <- with(test_data, ifelse(Üzemanyag_new == "Elektromos" & pred == "Elektromos", 
                                           "Elektromos",
                                           ifelse(Üzemanyag_new == "Fosszilis" & pred == "Fosszilis", 
                                                  "Fosszilis", 
                                                  "Helytelen")))

test_data$helyes <- as.factor(test_data$helyes)
test_data$helyes2 <- with(test_data, ifelse(helyes == "Helytelen", "Helytelen", "Helyes"))
test_data$helyes2 <- as.factor(test_data$helyes2)
#helyesen és nem helyesen klasszifikált adatok vizualizálása
ggplot(test_data, aes(x = Kor, y = Teljesítmény, color = helyes)) +
  geom_point(size = 2)
ggplot(test_data, aes(x = Kor, y = Teljesítmény, color = helyes2)) +
  geom_point(size = 2)

#standardizált adatok elkészítése
Train_data_scaled<- as.data.frame(scale(train_data[,-1]))
Train_data_scaled$Üzemanyag_new<- train_data$Üzemanyag_new

Test_data_scaled<- as.data.frame(scale(test_data[,2:6]))
Test_data_scaled$Üzemanyag_new<- test_data$Üzemanyag_new
#standardizált modell készítése
svm_model_scaled <- svm(Üzemanyag_new ~ ., data = Train_data_scaled, kernel = "radial")

predictions_scaled <- predict(svm_model_scaled, Test_data_scaled)

confusion_matrix <- table(Predicted = predictions_scaled, Actual = Test_data_scaled$Üzemanyag_new)
print(confusion_matrix)

accuracy <- sum(diag(confusion_matrix)) / sum(confusion_matrix)
print(paste("Pontosság:", accuracy))
summary(test_data)

#vizualizációk
Test_data_scaled$pred<-predictions_scaled
ggplot(Test_data_scaled, aes(x = Kor, y = Teljesítmény, color = pred)) +
  geom_point(size = 2)
ggplot(Test_data_scaled, aes(x = Kor, y = Teljesítmény, color = Üzemanyag_new)) +
  geom_point(size = 2)

Test_data_scaled$helyes <- with(Test_data_scaled, ifelse(Üzemanyag_new == "Elektromos" & pred == "Elektromos", 
                                           "Elektromos",
                                           ifelse(Üzemanyag_new == "Fosszilis" & pred == "Fosszilis", 
                                                  "Fosszilis", 
                                                  "Helytelen")))

Test_data_scaled$helyes <- as.factor(Test_data_scaled$helyes)
Test_data_scaled$helyes2 <- with(Test_data_scaled, ifelse(helyes == "Helytelen", "Helytelen", "Helyes"))
Test_data_scaled$helyes2 <- as.factor(Test_data_scaled$helyes2)
#helyesen és nem helyesen klasszifikált adatok vizualizálása
ggplot(Test_data_scaled, aes(x = Kor, y = Teljesítmény, color = helyes)) +
  geom_point(size = 2)
ggplot(Test_data_scaled, aes(x = Kor, y = Teljesítmény, color = helyes2)) +
  geom_point(size = 2)


#######
tune_grid <- expand.grid(C = 2^(0:2), 
                         sigma = 2^(0:2))  

train_control <- trainControl(method = "cv", number = 5)  

svm_tuned <- train(Üzemanyag_new ~ ., 
                   data = Train_data_scaled, 
                   method = "svmRadial",
                   tuneGrid = tune_grid,
                   trControl = train_control)

best_params2 <- svm_tuned$bestTune
print(best_params2)

svm_final <- svm(Üzemanyag_new ~ ., data = Train_data_scaled, kernel = "radial", cost = best_params2$C, gamma = best_params2$sigma)

predictions <- predict(svm_final, Test_data_scaled)

confusion_matrix <- table(Predicted = predictions, Actual = test_data$Üzemanyag_new)
print(confusion_matrix)

accuracy <- sum(diag(confusion_matrix)) / sum(confusion_matrix)
print(paste("Pontosság:", accuracy))
summary(Test_data_scaled)

Test_data_scaled$pred<-predictions
ggplot(Test_data_scaled, aes(x = Kor, y = Teljesítmény, color = pred)) +
  geom_point(size = 2)
ggplot(Test_data_scaled, aes(x = Kor, y = Teljesítmény, color = Üzemanyag_new)) +
  geom_point(size = 2)

Test_data_scaled$helyes <- with(Test_data_scaled, ifelse(Üzemanyag_new == "Elektromos" & pred == "Elektromos", 
                                                         "Elektromos",
                                                         ifelse(Üzemanyag_new == "Fosszilis" & pred == "Fosszilis", 
                                                                "Fosszilis", 
                                                                "Helytelen")))

Test_data_scaled$helyes <- as.factor(Test_data_scaled$helyes)
Test_data_scaled$helyes2 <- with(Test_data_scaled, ifelse(helyes == "Helytelen", "Helytelen", "Helyes"))
Test_data_scaled$helyes2 <- as.factor(Test_data_scaled$helyes2)
#helyesen és nem helyesen klasszifikált adatok vizualizálása
ggplot(Test_data_scaled, aes(x = Kor, y = Teljesítmény, color = helyes)) +
  geom_point(size = 2)
ggplot(Test_data_scaled, aes(x = Kor, y = Teljesítmény, color = helyes2)) +
  geom_point(size = 2)
summary(Test_data_scaled$helyes2)
